package applet;

import static sidplay.ConsolePlayer.playerFast;
import static sidplay.ConsolePlayer.playerRestart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import sidplay.ConsolePlayer;

/**
 * @author Ken Hndel
 * 
 * SID Player GUI
 */
@SuppressWarnings("serial")
public class JSIDPlay2 extends JFrame implements Runnable, ActionListener {

	public static final int NONE = 0;

	public static final int VIEW_INTERNALS = 1;

	public static final int VIEW_CONTROLS = 2;

	public int viewMode = VIEW_INTERNALS | VIEW_CONTROLS;

	boolean noapplet = false;

	public boolean gui = true;

	private JPanel sidPanel;

	private SIDCanvas[] sidCanvas = new SIDCanvas[3];

	FileDialog fileDialog;

	JButton fPreviousButton;

	JButton fNextButton;

	private String[] args;

	private ConsolePlayer cp;

	private Thread fPlayerThread;

	private JButton fLoadButton;

	public JSIDPlay2(String[] args) {
		this.args = args;
	}

	public void noapplet() {
		noapplet = true;
	}

	public void init() {
		if (gui) {
			createFrame();
		}
	}

	public void start() {
		fPlayerThread = new Thread(this);
		fPlayerThread.start();
	}

	public void run() {
		CursorToolkitOne.startWaitCursor(sidPanel);
		
		cp = new ConsolePlayer("java -jar jsidplay2.jar");
		if (cp.args(args) < 0) {
			System.exit(1);
		}
		main_restart: while (true) {
			if (!cp.open()) {
				cp.close();
				System.exit(0);
			}

			updateButtonTexts();
			CursorToolkitOne.stopWaitCursor(sidPanel);
			
			while (true) {
				if (!cp.play())
					break;
			}
			if ((cp.state() & ~playerFast) == playerRestart)
				continue main_restart;
			break;
		}
		cp.close();
	}

	/**
	 * Update the buttons according to the currently played song number
	 */
	private void updateButtonTexts() {
		int prevSong = cp.getCurrentSong() - 1;
		if (prevSong < 1)
			prevSong = cp.getSongCount();
		fPreviousButton.setText("Previous Song(" + prevSong + ")");
		int nextSong = cp.getCurrentSong() + 1;
		if (nextSong > cp.getSongCount())
			nextSong = 1;
		fNextButton.setText("Next Song(" + nextSong + ")");
		fLoadButton.setText("Load SID(" + cp.getCurrentSong() + "/"
				+ cp.getSongCount() + ")");
	}

	/**
	 * Create the Frame. Display GUI, buttons etc.
	 */
	private void createFrame() {
		JPanel panel;
		if (viewMode != NONE) {
			sidPanel = new JPanel(new GridLayout(0, 1));
			sidPanel.setBackground(Color.black);
		}
		Container cp = getContentPane();
		cp.setLayout(new BorderLayout());
		panel = new JPanel(new GridLayout(0, 4, 0, 0));
		cp.add(panel, BorderLayout.NORTH);
		if (sidPanel != null)
			cp.add(sidPanel, BorderLayout.CENTER);
		// SIDMixerFront smf = new SIDMixerFront(sids.mixer);
		// cp.add(smf.getPanel(), BorderLayout.SOUTH);

		if ((viewMode & VIEW_INTERNALS) != 0) {
			sidPanel.add(sidCanvas[0] = new SIDCanvas());
			sidPanel.add(sidCanvas[1] = new SIDCanvas());
			sidPanel.add(sidCanvas[2] = new SIDCanvas());
			sidPanel.add(new PSIDCanvas());
		}

		// if ((viewMode & VIEW_CONTROLS) != 0) {
		// cp.add(new SIDMixerFront(sids.mixer).getPanel(), BorderLayout.SOUTH);
		// }

		fLoadButton = new JButton("Load SID");
		fLoadButton.addActionListener(this);
		panel.add(fLoadButton);

		// butt = new JButton("Init SID");
		// butt.addActionListener(this);
		// panel.add(butt);
		//		 
		fPreviousButton = new JButton("Previous Song");
		fPreviousButton.addActionListener(this);
		panel.add(fPreviousButton);

		fNextButton = new JButton("Next Song");
		fNextButton.addActionListener(this);
		panel.add(fNextButton);

		JButton pauseButton = new JButton("Pause Player");
		pauseButton.addActionListener(this);
		panel.add(pauseButton);

		JButton quitButton = new JButton("Quit Player");
		quitButton.addActionListener(this);
		panel.add(quitButton);

		JButton normalButton = new JButton("Normal Speed");
		normalButton.addActionListener(this);
		panel.add(normalButton);

		JButton fastButton = new JButton("Fast Forward");
		fastButton.addActionListener(this);
		panel.add(fastButton);
	}

	public void actionPerformed(ActionEvent ae) {
		String cmd = ae.getActionCommand();
		if (cmd.startsWith("Load SID")) {
			if (fileDialog == null)
				fileDialog = new FileDialog((Frame) this, "Select File to Load");
			fileDialog.setVisible(true);
			if (fileDialog.getFile() != null) {
				String name = fileDialog.getDirectory() + fileDialog.getFile();
				play(name);
			}
		} else if (cmd.startsWith("Quit")) {
			cp.quit();
			while (fPlayerThread.isAlive()) {
				try {
					Thread.sleep(500);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			dispose();
		} else if (cmd.startsWith("Pause")) {
			JButton b = (JButton) ae.getSource();
			b.setText("Continue Player");
			setPause();
		} else if (cmd.startsWith("Continue")) {
			JButton b = (JButton) ae.getSource();
			b.setText("Pause Player");
			setPause();
		}
		if (cmd.startsWith("Normal Speed")) {
			cp.normalSpeed();
		} else if (cmd.startsWith("Fast Forward")) {
			cp.fastForward();
		} else if (cmd.startsWith("Previous Song")) {
			cp.previousSong();
		} else if (cmd.startsWith("Next Song")) {
			cp.nextSong();
		}
	}

	private void play(String name) {
		cp.quit();
		while (fPlayerThread.isAlive()) {
			try {
				Thread.sleep(500);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		args = new String[] { name };
		fPlayerThread = new Thread(this);
		fPlayerThread.start();
	}

	private void setPause() {
		cp.pause();
	}

	public static void main(String[] args) {
		try {
			// Set cross-platform Java L&F (also called "Metal")
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (UnsupportedLookAndFeelException e) {
			// handle exception
		} catch (ClassNotFoundException e) {
			// handle exception
		} catch (InstantiationException e) {
			// handle exception
		} catch (IllegalAccessException e) {
			// handle exception
		}
		JSIDPlay2 sp = new JSIDPlay2(args);
		sp.noapplet();
		// sp.viewMode = VIEW_CONTROLS;//INTERNALS;
		sp.init();
		sp.start();
		sp.setSize(640, 480);
		sp.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		sp.setVisible(true);
	}
}
